# DX makefile
# TM component
#

COMP_NAME = $(TM_ID)

#id's of the components this component depends on
$(COMP_NAME)_DEPEND_ON_APIS := 

#id's of the components whose objects are used by this component
$(COMP_NAME)_USE_OBJ_IDS := 

#paths of this component API include directories
$(COMP_NAME)_API_INCL_PATH := \
	$(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/

#paths of the internal include directories
$(COMP_NAME)_INTERNAL_INCL_PATH := \
	

#global flags for this component
$(COMP_NAME)_CCFLAGS := 
#project-specific flags for this component should be added to $($(COMP_NAME)_SPECIFIC_CCFLAGS) outside of this makefile

#the objects names without path or extension
$(COMP_NAME)_OBJ_NAMES := \
	bncore bn_error bn_fast_mp_invmod bn_fast_mp_montgomery_reduce bn_fast_s_mp_mul_digs \
	bn_fast_s_mp_mul_high_digs bn_fast_s_mp_sqr bn_mp_2expt bn_mp_abs bn_mp_add \
	bn_mp_addmod bn_mp_add_d bn_mp_and bn_mp_clamp bn_mp_clear \
	bn_mp_clear_multi bn_mp_cmp bn_mp_cmp_d bn_mp_cmp_mag bn_mp_cnt_lsb \
	bn_mp_copy bn_mp_count_bits bn_mp_div bn_mp_div_2 bn_mp_div_2d \
	bn_mp_div_3 bn_mp_div_d bn_mp_dr_is_modulus bn_mp_dr_reduce bn_mp_dr_setup \
	bn_mp_exch bn_mp_exptmod bn_mp_exptmod_fast bn_mp_expt_d bn_mp_exteuclid \
	bn_mp_fread bn_mp_fwrite bn_mp_gcd bn_mp_get_int bn_mp_grow \
	bn_mp_init bn_mp_init_copy bn_mp_init_multi bn_mp_init_set bn_mp_init_set_int \
	bn_mp_init_size bn_mp_invmod bn_mp_invmod_slow bn_mp_is_square bn_mp_jacobi \
	bn_mp_karatsuba_mul bn_mp_karatsuba_sqr bn_mp_lcm bn_mp_lshd bn_mp_mod \
	bn_mp_mod_2d bn_mp_mod_d bn_mp_montgomery_calc_normalization bn_mp_montgomery_reduce bn_mp_montgomery_setup \
	bn_mp_mul bn_mp_mulmod bn_mp_mul_2 bn_mp_mul_2d bn_mp_mul_d \
	bn_mp_neg bn_mp_n_root bn_mp_or bn_mp_prime_fermat bn_mp_prime_is_divisible \
	bn_mp_prime_is_prime bn_mp_prime_miller_rabin bn_mp_prime_next_prime bn_mp_prime_rabin_miller_trials bn_mp_prime_random_ex \
	bn_mp_radix_size bn_mp_radix_smap bn_mp_rand bn_mp_read_radix bn_mp_read_signed_bin \
	bn_mp_read_unsigned_bin bn_mp_reduce bn_mp_reduce_2k bn_mp_reduce_2k_l bn_mp_reduce_2k_setup \
	bn_mp_reduce_2k_setup_l bn_mp_reduce_is_2k bn_mp_reduce_is_2k_l bn_mp_reduce_setup bn_mp_rshd \
	bn_mp_set bn_mp_set_int bn_mp_shrink bn_mp_signed_bin_size bn_mp_sqr \
	bn_mp_sqrmod bn_mp_sqrt bn_mp_sub bn_mp_submod bn_mp_sub_d \
	bn_mp_toom_mul bn_mp_toom_sqr bn_mp_toradix bn_mp_toradix_n bn_mp_to_signed_bin \
	bn_mp_to_signed_bin_n bn_mp_to_unsigned_bin bn_mp_to_unsigned_bin_n bn_mp_unsigned_bin_size bn_mp_xor \
	bn_mp_zero bn_prime_tab bn_reverse bn_s_mp_add bn_s_mp_exptmod \
	bn_s_mp_mul_digs bn_s_mp_mul_high_digs bn_s_mp_sqr bn_s_mp_sub \
	2kprime drprime mersenne mont \
	pprime tune

$(COMP_NAME)_MAIN_OBJ_NAMES := \
	

#Use the above specific settings for building the components properties with the standard rules:
include $(MF_PATH)DX_STD_RULES.inc

##  OBJECT RULES - ADD RULES FOR NEW SOURCE FILES
#   make sure to add obj_name to the above list: $(COMP_NAME)_OBJS
#   this is the template for rules:
#$(OUT_OBJ_PATH)<<OBJ_NAME>>.$(OBJEXT): $(HOST_PATH)<<SOURCE_PATH>>
#	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@
$(OUT_OBJ_PATH)bncore.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bncore.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_error.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_error.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_fast_mp_invmod.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_fast_mp_invmod.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_fast_mp_montgomery_reduce.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_fast_mp_montgomery_reduce.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_fast_s_mp_mul_digs.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_fast_s_mp_mul_digs.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_fast_s_mp_mul_high_digs.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_fast_s_mp_mul_high_digs.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_fast_s_mp_sqr.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_fast_s_mp_sqr.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_2expt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_2expt.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_abs.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_abs.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_add.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_add.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_addmod.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_addmod.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_add_d.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_add_d.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_and.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_and.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_clamp.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_clamp.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_clear.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_clear.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_clear_multi.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_clear_multi.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_cmp.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_cmp.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_cmp_d.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_cmp_d.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_cmp_mag.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_cmp_mag.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_cnt_lsb.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_cnt_lsb.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_copy.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_copy.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_count_bits.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_count_bits.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_div.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_div.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_div_2.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_div_2.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_div_2d.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_div_2d.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_div_3.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_div_3.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_div_d.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_div_d.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_dr_is_modulus.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_dr_is_modulus.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_dr_reduce.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_dr_reduce.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_dr_setup.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_dr_setup.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_exch.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_exch.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_exptmod.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_exptmod.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_exptmod_fast.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_exptmod_fast.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_expt_d.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_expt_d.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_exteuclid.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_exteuclid.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_fread.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_fread.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_fwrite.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_fwrite.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_gcd.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_gcd.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_get_int.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_get_int.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_grow.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_grow.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_init.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_init.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_init_copy.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_init_copy.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_init_multi.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_init_multi.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_init_set.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_init_set.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_init_set_int.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_init_set_int.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_init_size.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_init_size.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_invmod.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_invmod.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_invmod_slow.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_invmod_slow.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_is_square.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_is_square.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_jacobi.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_jacobi.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_karatsuba_mul.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_karatsuba_mul.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_karatsuba_sqr.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_karatsuba_sqr.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_lcm.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_lcm.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_lshd.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_lshd.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_mod.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_mod.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_mod_2d.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_mod_2d.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_mod_d.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_mod_d.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_montgomery_calc_normalization.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_montgomery_calc_normalization.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_montgomery_reduce.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_montgomery_reduce.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_montgomery_setup.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_montgomery_setup.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_mul.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_mul.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_mulmod.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_mulmod.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_mul_2.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_mul_2.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_mul_2d.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_mul_2d.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_mul_d.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_mul_d.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_neg.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_neg.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_n_root.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_n_root.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_or.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_or.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_prime_fermat.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_prime_fermat.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_prime_is_divisible.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_prime_is_divisible.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_prime_is_prime.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_prime_is_prime.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_prime_miller_rabin.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_prime_miller_rabin.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_prime_next_prime.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_prime_next_prime.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_prime_rabin_miller_trials.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_prime_rabin_miller_trials.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_prime_random_ex.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_prime_random_ex.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_radix_size.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_radix_size.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_radix_smap.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_radix_smap.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_rand.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_rand.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_read_radix.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_read_radix.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_read_signed_bin.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_read_signed_bin.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_read_unsigned_bin.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_read_unsigned_bin.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_reduce.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_reduce.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_reduce_2k.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_reduce_2k.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_reduce_2k_l.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_reduce_2k_l.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_reduce_2k_setup.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_reduce_2k_setup.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_reduce_2k_setup_l.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_reduce_2k_setup_l.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_reduce_is_2k.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_reduce_is_2k.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_reduce_is_2k_l.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_reduce_is_2k_l.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_reduce_setup.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_reduce_setup.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_rshd.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_rshd.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_set.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_set.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_set_int.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_set_int.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_shrink.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_shrink.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_signed_bin_size.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_signed_bin_size.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_sqr.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_sqr.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_sqrmod.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_sqrmod.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_sqrt.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_sqrt.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_sub.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_sub.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_submod.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_submod.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_sub_d.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_sub_d.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_toom_mul.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_toom_mul.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_toom_sqr.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_toom_sqr.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_toradix.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_toradix.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_toradix_n.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_toradix_n.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_to_signed_bin.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_to_signed_bin.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_to_signed_bin_n.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_to_signed_bin_n.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_to_unsigned_bin.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_to_unsigned_bin.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_to_unsigned_bin_n.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_to_unsigned_bin_n.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_unsigned_bin_size.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_unsigned_bin_size.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_xor.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_xor.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_mp_zero.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_mp_zero.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_prime_tab.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_prime_tab.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_reverse.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_reverse.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_s_mp_add.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_s_mp_add.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_s_mp_exptmod.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_s_mp_exptmod.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_s_mp_mul_digs.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_s_mp_mul_digs.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_s_mp_mul_high_digs.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_s_mp_mul_high_digs.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_s_mp_sqr.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_s_mp_sqr.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)bn_s_mp_sub.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/bn_s_mp_sub.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)demo.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/demo/demo.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

#~ $(OUT_OBJ_PATH)timing.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/demo/timing.c
	#~ $(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)2kprime.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/etc/2kprime.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drprime.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/etc/drprime.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)mersenne.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/etc/mersenne.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)mont.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/etc/mont.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pprime.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/etc/pprime.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)tune.$(OBJEXT): $(BASE_PATH)QAT_LibTomCrypt/TCLib_TomMath/etc/tune.c
	$(TM_CC_CMD) $< $(CCFLAG_OUTPUT) $@
